package org.matrix.local.entity.config;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.List;
import java.util.Map;

/**
 * BookmarkConfig.
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2022/6/14 at 4:05 PM
 * Suffering is the most powerful teacher of life.
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Document
@ApiModel("书签配置")
public class BookmarkConfig {

    @ApiModelProperty(value = "项目id",example = "22")
    private Long projectId;

    /**
     * 用例收藏夹id
     */
    @ApiModelProperty(value = "用例收藏夹id",example = "[1,2,3]")
    private List<Long> hobby;

    /**
     * 最近几次使用的用例
     */
    @ApiModelProperty(value = "最近几次使用的用例",example = "[1,2,3]")
    private List<Long> recentUse;

    /**
     * 自定义书签,key = 书签名, value = 书签里包含的用例id
     */
    @ApiModelProperty(value = "最近几次使用的用例")
    private Map<String,List<Long>> customDir;
}


