package org.matrix.local.entity.config;


import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.List;

@Data
@NoArgsConstructor
@AllArgsConstructor
@Document
@ApiModel("接收消息配置")
public class MessageConfig {

    /**
     * 可接收的类型
     */
    @ApiModelProperty(value = "可接收的类型,等同与对应数据的java类名",example = "['Action','Environment','Case']")
    private List<String> available;

}
