package org.matrix.local.entity.config;

import cn.craccd.mongoHelper.bean.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import org.springframework.data.mongodb.core.mapping.Document;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.util.List;


/**
 * UserConfig. 用户的个人配置
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2022/6/14 at 3:47 PM
 * Suffering is the most powerful teacher of life.
 */
@Data
@Document
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@ApiModel("用户配置")
public class UserConfig extends BaseModel {

    public UserConfig(Long userId, List<BookmarkConfig> bookmark) {
        this.userId = userId;
        this.bookmark = bookmark;
    }

    /**
     * 用户id
     */
    @Min(1)
    @NotNull
    @ApiModelProperty(value = "用户id",example = "2")
    private Long userId;


    /**
     * 书签配置
     */
    @ApiModelProperty(value = "书签配置")
    private List<BookmarkConfig> bookmark;


    /**
     * 接收消息配置
     */
    @ApiModelProperty(value = "接收消息配置")
    private MessageConfig messageConfig;



}
