package org.matrix.local.enums;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Getter;


/**
 * @author C
 * 权限枚举
 */
@AllArgsConstructor
@Getter
@ApiModel("角色权限")
public enum  Authority {


    READ("read","查看数据以及配置"),
    EXECUTE("execute","执行测试"),
    EDIT("edit","编辑数据以及配置"),
    MANAGE("manage","项目的管理权限"),
    ADMIN("admin","管理员权限");

    @ApiModelProperty("权限名称")
    private final String name;

    @ApiModelProperty("权限描述")
    private final String description;

}
