package org.matrix.local.enums;

import io.swagger.annotations.ApiModel;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * ConfigType. 配置类型
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2022/6/16 at 9:36 PM
 * Suffering is the most powerful teacher of life.
 */
@AllArgsConstructor
@Getter
@ApiModel("配置类型")
public enum ConfigType {

    /**
     * 全局配置,使用该类型代表进行全局的配置替换
     */
    ALL("all", "全局配置,使用该类型代表进行全局的配置替换"),

    /**
     * 书签
     */
    BOOK_MARK("bookmark", "书签"),

    MESSAGE("message","接收消息配置");

    /**
     * 配置类型在mongo里的字段名
     */
    private final String propertyName;

    /**
     * 描述
     */
    private final String des;

}
