package org.matrix.local.enums;

import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.*;
import java.util.stream.Collectors;

import static org.matrix.local.enums.Authority.*;

/**
 * @author C
 * 角色枚举常量
 */
@AllArgsConstructor
@Getter
@ApiModel("用户角色")
public enum Role {

    NORMAL("normal", "普通成员", Lists.newArrayList(READ, EXECUTE)),
    SENIOR("senior", "高级成员", Lists.newArrayList(READ, EXECUTE, EDIT)),
    CREATOR("creator", "创建者", Lists.newArrayList(READ, EXECUTE, EDIT, MANAGE)),
    ADMIN("admin", "管理员", Lists.newArrayList(READ, EXECUTE, EDIT, MANAGE, Authority.ADMIN));

    @ApiModelProperty("角色名称")
    private final String name;

    @ApiModelProperty("角色描述")
    private final String description;

    @ApiModelProperty("角色拥有的权限")
    private final List<Authority> authorities;

    public static List<Authority> getAuthorities(String role) {
        for (Role value : Role.values()) {
            if (Objects.equals(role, value.getName())) {
                return value.getAuthorities();
            }
        }
        return Collections.emptyList();
    }

    public static Set<String> roles() {
        return Arrays.stream(Role.values())
                .map(Role::getName)
                .collect(Collectors.toSet());
    }
}
