package org.matrix.remote.service;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import org.apache.logging.log4j.util.Strings;
import org.matrix.datasource.IDataSourceService;
import org.matrix.local.entity.Project;
import org.matrix.local.entity.User;
import org.matrix.local.entity.relation.UserProject;
import org.matrix.local.enums.Role;
import org.matrix.local.mapper.UserMapper;
import org.matrix.remote.entity.ZtProject;
import org.matrix.remote.entity.ZtUser;
import org.matrix.remote.entity.ZtUserView;
import org.matrix.remote.mapper.ZtProjectMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

import static java.util.Objects.nonNull;

/**
 * 数据类型转换器
 */
@Service
public class TransHelper {

    @Autowired
    private ZtProjectMapper ztProjectMapper;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private IDataSourceService dataSourceService;

    public User user(ZtUser ztUser) {
        return new User(Long.valueOf(ztUser.getId()), ztUser.getRealname(), ztUser.getAccount(), ztUser.getPassword(), Role.NORMAL.getName());
    }

    public Project project(ZtProject ztProject) {
        return new Project(Long.valueOf(ztProject.getId()), ztProject.getName());
    }

    List<UserProject> userProjects(ZtUserView ztUserView) {
        dataSourceService.switchMainDataSource();
        User user = userMapper.selectOne(Wrappers.<User>lambdaQuery().eq(User::getAccount, ztUserView.getAccount()));
        if (nonNull(user)) {
            dataSourceService.switchDataSource("zentao");
            return toList(ztUserView.getProjects()).stream()
                    .map(Integer::parseInt)
                    .map(id -> ztProjectMapper.selectById(id))
                    .filter(ztProject -> Objects.equals("0", ztProject.getDeleted()))
                    .map(ztProject1 -> userProject(ztProject1,user))
                    .collect(Collectors.toList());
        } else {
            return new ArrayList<>();
        }
    }

    //private---------------------------------------------------------------------------

    private UserProject userProject(ZtProject ztProject,User user){
        Long projectId = findProjectId(ztProject);
        Long userId = user.getId();
        String role = Role.NORMAL.getName();
        if (Objects.equals(user.getAccount(),ztProject.getPm())){
            role = Role.CREATOR.getName();
        }
        return new UserProject()
                .setUserId(userId)
                .setProjectId(projectId)
                .setRole(role);
    }

    private Long findProjectId(ZtProject ztProject) {
        if (nonNull(ztProject.getProject()) && ztProject.getProject() > 0) {
            return Long.valueOf(ztProject.getProject());
        } else {
            return Long.valueOf(ztProject.getId());
        }
    }

    private List<String> toList(String content) {
        List<String> result = Arrays.stream(content.split(",")).collect(Collectors.toList());
        result.remove(0);
        return result;
    }

}
