package org.matrix.remote.task;

import lombok.extern.slf4j.Slf4j;
import org.matrix.datasource.DataSourceDTO;
import org.matrix.datasource.IDataSourceService;
import org.matrix.remote.service.DataAllCollector;
import org.matrix.remote.service.DataTriggerCollector;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

/**
 * 定时任务
 */
@Slf4j
@Component
public class DataCollectorTask implements CommandLineRunner {

    @Autowired
    private DataAllCollector dataAllCollector;
    @Autowired
    private DataTriggerCollector dataTriggerCollector;
    @Autowired
    private IDataSourceService dataSourceService;

    /**
     * 禅道数据同步组件是否运行的flag
     * 如果未能读取到禅道数据源
     * 则置为false
     * 从而使禅道数据同步组件停止运行
     */
    private boolean running = true;

    /**
     * 在项目刚启动时进行一次全量同步
     * 后续则轮询进行增量同步
     */
    @Override
    public void run(String... args) {
        initDataSource();
        allCollect();
    }

    /**
     * 全量同步禅道取的用户和项目数据
     * 在项目启动时执行一次
     */
    private void allCollect() {
        if (running) {
            dataAllCollector.execute();
        }
    }

    /**
     * 增量同步禅道取的用户和项目数据
     * 每分钟收集一次
     */
    @Scheduled(cron = "0 */1 * * * ?")
    private void triggerCollect() {
        if (running) {
            dataTriggerCollector.execute();
        }
    }

    private void initDataSource() {
        log.info("初始化禅道数据源...");
        try {
            String driverClassName = "com.mysql.cj.jdbc.Driver";
            String url = "jdbc:mysql://192.168.100.247:3306/zentao?useUnicode=true&characterEncoding=utf-8&useSSL=false&serverTimezone=UTC&&zeroDateTimeBehavior=convertToNull";
            String username = "root";
            String password = "123456";
            DataSourceDTO zentao = new DataSourceDTO("zentao", driverClassName, url, username, password);
            dataSourceService.add(zentao);
        } catch (Exception e) {
            log.warn("未能读取到禅道数据源...");
            running = false;
        }
    }

}
