package org.matrix.autotest.controller;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import org.matrix.entity.Case;
import org.matrix.entity.InterfaceDoc;
import org.matrix.exception.GlobalException;
import org.matrix.service.ICaseService;
import org.matrix.service.IInterfaceDocService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

/**
 * @author mruny
 * @create 2022/8/1 10:11:52
 */
@CrossOrigin
@RestController
@RequestMapping("/interfaceDocs")
@Api(tags = "对接口文档InterfaceDoc的基本操作")
public class InterfaceDocController {

    @Autowired
    private IInterfaceDocService interfaceDocService;

    @Autowired
    private ICaseService caseService;

    @ApiOperation("根据id删除接口文档，以及接口文档中的测试用例")
    @DeleteMapping("/{id}")
    @Transactional(rollbackFor = Exception.class)
    public ResponseEntity<String> removeInterfaceDoc(@PathVariable Long id) {
        List<Case> cases = Optional.of(caseService.list(Wrappers.lambdaQuery(Case.class)
                .eq(Case::getDocId, id))).orElse(new ArrayList<>());
        caseService.removeByIds(cases);
        interfaceDocService.removeById(id);
        return ResponseEntity.ok(String.format("删除成功，删除的接口文档id为: %d", id));
    }

    @ApiModelProperty("添加接口文档")
    @PostMapping
    public ResponseEntity<InterfaceDoc> insertInterfaceDoc(@RequestBody InterfaceDoc interfaceDoc) {
        return Optional.of(interfaceDocService.save(interfaceDoc)).orElseThrow(() -> new GlobalException("添加失败"))
                ? ResponseEntity.ok(interfaceDoc)
                : ResponseEntity.status(HttpStatus.BAD_REQUEST).body(interfaceDoc);
    }

    @ApiOperation("修改接口文档")
    @PutMapping
    public ResponseEntity<InterfaceDoc> updateInterfaceDoc(@RequestBody InterfaceDoc interfaceDoc) {
        return Optional.of(interfaceDocService.updateById(interfaceDoc)).orElseThrow(() -> new GlobalException("添加失败"))
                ? ResponseEntity.ok(interfaceDoc)
                : ResponseEntity.status(HttpStatus.BAD_REQUEST).body(interfaceDoc);
    }

    @ApiOperation("根据主键id查询接口文档")
    @GetMapping("/id")
    public ResponseEntity<InterfaceDoc> findByIdInterfaceDoc(@RequestParam Long id) {
        InterfaceDoc interfaceDoc = Optional.ofNullable(interfaceDocService.getById(id)).orElse(new InterfaceDoc());
        return ResponseEntity.ok(interfaceDoc);
    }

}
