package org.matrix.autotest.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.matrix.entity.InterfaceGrouping;
import org.matrix.exception.GlobalException;
import org.matrix.service.IInterfaceGroupingService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.*;

import java.util.Optional;

/**
 * @author mruny
 * @create 2022/8/1 10:12:10
 */
@CrossOrigin
@RestController
@RequestMapping("/interfaceGroupings")
@Api(tags = "对接口文档分组InterfaceGrouping的基本操作")
public class InterfaceGroupingController {

    @Autowired
    private IInterfaceGroupingService interfaceGroupingService;

    @ApiOperation("添加接口分组")
    @PostMapping
    public ResponseEntity<InterfaceGrouping> insertInterfaceGrouping(@RequestBody InterfaceGrouping interfaceGrouping) {
        return Optional.of(interfaceGroupingService.save(interfaceGrouping)).orElseThrow(() -> new GlobalException("添加失败"))
                ? ResponseEntity.ok(interfaceGrouping)
                : ResponseEntity.status(HttpStatus.BAD_REQUEST).body(interfaceGrouping);
    }

    @ApiOperation("修改接口分组")
    @PutMapping
    public ResponseEntity<InterfaceGrouping> updateInterfaceGrouping(@RequestBody InterfaceGrouping interfaceGrouping) {
        return Optional.of(interfaceGroupingService.updateById(interfaceGrouping)).orElseThrow(() -> new GlobalException("添加失败"))
                ? ResponseEntity.ok(interfaceGrouping)
                : ResponseEntity.status(HttpStatus.BAD_REQUEST).body(interfaceGrouping);
    }

    @ApiOperation("根据主键id查询接口分组")
    @GetMapping("/id")
    public ResponseEntity<InterfaceGrouping> findByIdInterfaceGrouping(@RequestParam Long id) {
        InterfaceGrouping interfaceGrouping = Optional.ofNullable(interfaceGroupingService.getById(id)).orElse(new InterfaceGrouping());
        return ResponseEntity.ok(interfaceGrouping);
    }

    @ApiOperation("根据接口分组主键id删除分组以及分组下所有分组和接口文档")
    @DeleteMapping("/{id}")
    @Transactional(rollbackFor = Exception.class)
    public ResponseEntity<String> removeInterfaceGrouping(@PathVariable Long id) {
        interfaceGroupingService.removeInterfaceGrouping(id);
        return ResponseEntity.ok(String.format("删除成功,删除的接口分组id为: %d", id));
    }

}
