package org.matrix.autotest.controller;

import com.alibaba.fastjson.JSON;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.matrix.utils.JsonUtil;
import org.matrix.entity.Connect;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Objects;

/**
 * TestController.
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2022/3/22 at 4:56 PM
 * Suffering is the most powerful teacher of life.
 */
@Api(tags = "一个单纯的测试接口,开发完之后会删除")
@RestController
@RequestMapping("/justTest")
public class JustTestController {

    @GetMapping
    @ApiOperation("普通的测试接口,开发完会删除")
    public ResponseEntity<String> justForTest() {
        //todo 开发完毕后会删除
        return ResponseEntity.ok("这是一个单纯的测试接口");
    }

    @GetMapping("/jsonFormat")
    @ApiOperation("测试静态注入的jackson的美化功能")
    public ResponseEntity<String> jsonFormatTest() {
        Connect connect = new Connect("测试", "测试", "测试", "测试", "测试", 2L);
        String fastJsonString = JSON.toJSONString(connect);
        String jacksonString1 = JsonUtil.toJson(connect);
        String jacksonString2 = JsonUtil.toJsonPretty(connect);
        System.out.printf("fastJsonString = %s %n jacksonString1 = %s %n jacksonString2 %s %n %n",
                fastJsonString, jacksonString1, jacksonString2);
        return ResponseEntity.ok(Objects.requireNonNull(fastJsonString));
    }
}
