package org.matrix.autotest.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.matrix.entity.MouldDoc;
import org.matrix.exception.GlobalException;
import org.matrix.service.IMouldDocService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.Optional;

/**
 * @author mruny
 * @create 2022/7/18 13:35:36
 */
@CrossOrigin
@RestController
@RequestMapping("/mouldDocs")
@Api(tags = "对数据模型MouldDoc的基本操作")
public class MouldDocController {

    @Autowired
    private IMouldDocService mouldDocService;

    @ApiOperation("根据主键id删除数据模型")
    @DeleteMapping("/{id}")
    public ResponseEntity<String> removeMouldDoc(@PathVariable Long id) {
        mouldDocService.removeById(id);
        return ResponseEntity.ok(String.format("删除成功,删除的数据模型id为: %d", id));
    }

    @ApiOperation("添加数据模型")
    @PostMapping
    public ResponseEntity<MouldDoc> insertMouldDoc(@RequestBody MouldDoc mouldDoc) {
        return Optional.of(mouldDocService.save(mouldDoc)).orElseThrow(() -> new GlobalException("添加失败"))
                ? ResponseEntity.ok(mouldDoc)
                : ResponseEntity.status(HttpStatus.BAD_REQUEST).body(mouldDoc);
    }

    @ApiOperation("修改数据模型")
    @PutMapping
    public ResponseEntity<MouldDoc> updateMouldDoc(@RequestBody MouldDoc mouldDoc) {
        return Optional.of(mouldDocService.updateById(mouldDoc)).orElseThrow(() -> new GlobalException("修改失败"))
                ? ResponseEntity.ok(mouldDoc)
                : ResponseEntity.status(HttpStatus.BAD_REQUEST).body(mouldDoc);
    }

    @ApiOperation("根据主键id查询数据模型")
    @GetMapping("/id")
    public ResponseEntity<MouldDoc> findByIdMouldDoc(@RequestParam Long id) {
        MouldDoc mouldDoc = Optional.ofNullable(mouldDocService.getById(id)).orElse(new MouldDoc());
        return ResponseEntity.ok(mouldDoc);
    }

}
