package org.matrix.autotest.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.matrix.entity.MouldGrouping;
import org.matrix.exception.GlobalException;
import org.matrix.service.IMouldGroupingService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.*;

import java.util.Optional;

/**
 * @author mruny
 * @create 2022/7/18 13:15:08
 */
@CrossOrigin
@RestController
@RequestMapping("/mouldGroupings")
@Api(tags = "对数据模型分组MouldGrouping的基本操作")
public class MouldGroupingController {

    @Autowired
    private IMouldGroupingService mouldGroupingService;

    @PostMapping
    @ApiOperation("新增数据模型分组")
    public ResponseEntity<MouldGrouping> insertMouldGrouping(@RequestBody MouldGrouping mouldGrouping) {
        return Optional.of(mouldGroupingService.save(mouldGrouping)).orElseThrow(() -> new GlobalException("添加失败"))
                ? ResponseEntity.ok(mouldGrouping)
                : ResponseEntity.status(HttpStatus.BAD_REQUEST).body(mouldGrouping);
    }

    @PutMapping
    @ApiOperation("修改数据模型分组")
    public ResponseEntity<MouldGrouping> updateMouldGrouping(@RequestBody MouldGrouping mouldGrouping) {
        return Optional.of(mouldGroupingService.updateById(mouldGrouping)).orElseThrow(() -> new GlobalException("修改失败"))
                ? ResponseEntity.ok(mouldGrouping)
                : ResponseEntity.status(HttpStatus.BAD_REQUEST).body(mouldGrouping);
    }

    @ApiOperation("根据主键id查询数据模型分组")
    @GetMapping("/id")
    public ResponseEntity<MouldGrouping> findByMouldGrouping(@RequestParam Long id) {
        MouldGrouping mouldGrouping = Optional.ofNullable(mouldGroupingService.getById(id)).orElse(new MouldGrouping());
        return ResponseEntity.ok(mouldGrouping);
    }

    @ApiOperation("根据数据模型分组主键id，删除分组以及分组下所有分组和数据模型")
    @DeleteMapping("/{id}")
    @Transactional(rollbackFor = Exception.class)
    public ResponseEntity<String> removeMouldGrouping(@PathVariable Long id) {
        mouldGroupingService.removeMould(id);
        return ResponseEntity.ok(String.format("删除成功,删除的模型分组id为: %d", id));
    }

}
