package org.matrix.autotest.controller;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.matrix.entity.TestCase;
import org.matrix.entity.TestData;
import org.matrix.service.ITestCaseService;
import org.matrix.service.ITestDataService;
import org.matrix.vo.CommonResult;
import org.matrix.vo.CommonResultObj;
import org.matrix.vo.TestCaseData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

import static java.util.Optional.ofNullable;

/**
 * TestDataController
 * @author huangxiahao
 */
@CrossOrigin
@RestController
@RequestMapping("/testCases")
@Api(tags = "对用例test_data的基本操作")
public class TestDataController {

    @Autowired
    ITestCaseService testCaseService;

    @Autowired
    ITestDataService testDataService;

    /**
     * 根据projectId，查询出对应的TestData
     *
     * @return {@link TestCaseData}
     */
    @GetMapping("/listVo")
    @ApiOperation(value = "根据用例id查,用例以及,用例下的数据组")
    public ResponseEntity<CommonResultObj<List<TestCaseData>>> listVo(Long projectId) {
        List<TestCaseData> result = new ArrayList<>();
        List<TestCase> list = testCaseService.list(Wrappers.lambdaQuery(TestCase.class).eq(TestCase::getProjectId, projectId));
        for (TestCase testCase : list) {
            List<TestData> testDataList = ofNullable(testDataService.list(Wrappers.lambdaQuery(TestData.class)
                    .eq(TestData::getTestCaseId, testCase.getId())))
                    .orElse(new ArrayList<>());
            result.add(new TestCaseData(testCase,testDataList));
        }
        return CommonResult.success(result, "查询成功");
    }

}
