package org.matrix.autotest.controller;

import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.matrix.vo.CommonResultObj;
import org.matrix.local.entity.config.BookmarkConfig;
import org.matrix.local.entity.config.UserConfig;
import org.matrix.local.entity.vo.UserInfo;
import org.matrix.local.enums.ConfigType;
import org.matrix.local.service.impl.UserService;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;


import static org.matrix.vo.CommonResult.failed;
import static org.matrix.vo.CommonResult.success;

/**
 * UserConfigController.
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2022/6/14 at 4:49 PM
 * Suffering is the most powerful teacher of life.
 */
@Slf4j
@CrossOrigin
@RestController
@RequestMapping("/config")
@Api(tags = "用户配置")
public class UserConfigController {


    private final UserService userService;

    public UserConfigController(UserService userService) {
        this.userService = userService;
    }

    @ApiOperation("保存书签")
    @PostMapping("/bookmarks")
    public ResponseEntity<CommonResultObj<Object>> saveBookmark(@RequestBody @Validated BookmarkConfig bookmarkConfig){
        UserInfo userInfo = userService.findNow();
        UserConfig config = new UserConfig(userInfo.getId(), Lists.newArrayList(bookmarkConfig));
        boolean isSuccess = userService.upsertConfig(config, ConfigType.BOOK_MARK);
        return isSuccess ? success("书签更新成功") : failed("更新失败");
    }


}
