package org.matrix.actuators.httpclient;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.http.Header;
import org.springframework.http.HttpMethod;

import java.util.ArrayList;
import java.util.List;

/**
 * @author huangxiahao
 */
@Data
public class HttpRequestDetail {

    @ApiModelProperty("请求头")
    private List<RequestHeader> headers = new ArrayList<>();

    @ApiModelProperty("URL")
    private String url = "";

    @ApiModelProperty("请求类型")
    private HttpRequestType requestType = HttpRequestType.NONE;

    @ApiModelProperty("请求方法")
    private HttpMethod method;

    @ApiModelProperty("字符串入参")
    private String stringValue = "";

    @ApiModelProperty("键值对入参")
    private List<RequestBody> requestBodies = new ArrayList<>();

    @ApiModelProperty("复合参数组")
    private List<RequestParam> requestParams = new ArrayList<>();

    /**
     * 增加键值对入参
     */
    private Boolean addRequestBody(RequestBody requestBody) {
        return requestBodies.add(requestBody);
    }

    /**
     * 增加请求头
     */
    public void addHeaders(String name, String value) {
        headers.add(new RequestHeader(name, value));
    }

    /**
     * 以数组的形式获取请求头
     */
    public Header[] getHeadersArray() {
        return headers.stream().map(RequestHeader::getBasicHeader).toArray(Header[]::new);
    }


}
