package org.matrix.socket.queue;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.matrix.enums.ModuleType;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

/**
 * LogMessage. 日志的消息对象 封装了一些通用属性和消息
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2022/3/17 at 11:02 AM
 * Suffering is the most powerful teacher of life.
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class LogMessage {

    @JSONField(serialize = false)
    private LocalDateTime logTime;

    @JSONField(serialize = false)
    private ModuleType moduleType;

    private String msg;


    public String toLogString() {
        return String.format("[%s] %s", moduleType.getName(), msg);
    }

    @JSONField(name = "module")
    public String getModuleType() {
        return moduleType.getName();
    }

    @JSONField(name = "logTime")
    public String getFormatTime(){
        return logTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
    }
}
