package org.matrix.autotest.config;

import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

/**
 * ResourcesConfig.
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2022/3/17 at 10:25 AM
 * Suffering is the most powerful teacher of life.
 */
@Configuration
public class ResourcesConfig implements WebMvcConfigurer {
    @Override
    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        //localhost:8765/res/css/bootstrap.css
        String fileUrl = "file:" + System.getProperty("user.dir") + "/htmls/";
        registry.addResourceHandler("/res/**").addResourceLocations(fileUrl);
    }
}
