package org.matrix.autotest.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * GrammarTableField.
 * {@link  GrammarTable} 与 {@link  GrammarField} 两个对象的平展混合字段
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2022/3/25 at 11:24 AM
 * Suffering is the most powerful teacher of life.
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class GrammarTableField {

    @ApiModelProperty("表名")
    private String tableName;

    @ApiModelProperty("表描述")
    private String tableDes;

    @ApiModelProperty("字段名")
    private String fieldName;

    @ApiModelProperty("字段描述")
    private String fieldDes;

    @ApiModelProperty("字段类型")
    private String fieldType;

    public GrammarField extractField(){
        return new GrammarField(fieldName, fieldDes, fieldType);
    }
}
