package org.matrix.entity.httpRequest;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.http.client.methods.CloseableHttpResponse;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class HttpResponseDetail {

    @ApiModelProperty("HttpClient响应体")
    private CloseableHttpResponse response;

    @ApiModelProperty("响应的内容，已转换为字符串")
    private String responseBody = "error request";

    @ApiModelProperty("响应状态,例如:200、401、500")
    private Integer statusCode = 500;

    @ApiModelProperty("响应时间,单位为 ms ")
    private Long responseTime = 0l;


}
