package org.matrix.remote.task;

import lombok.extern.slf4j.Slf4j;
import org.matrix.remote.service.DataAllCollector;
import org.matrix.remote.service.DataTriggerCollector;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

/**
 * 定时任务
 */
@Slf4j
@Component
public class DataCollectorTask implements CommandLineRunner {

    @Autowired
    private DataAllCollector dataAllCollector;
    @Autowired
    private DataTriggerCollector dataTriggerCollector;

    /**
     * 全量同步禅道取的用户和项目数据
     * 每小时收集一次
     */
//    @Scheduled(cron = "0 0 */1 * * ?")
    public void allCollect() {
        dataAllCollector.execute();
    }

    /**
     * 增量同步禅道取的用户和项目数据
     * 每分钟收集一次
     */
    @Scheduled(cron = "0 */1 * * * ?")
    public void triggerCollect() {
        dataTriggerCollector.execute();
    }

    /**
     * 在项目刚启动时进行一次全量同步
     * 后续则轮询进行增量同步
     */
    @Override
    public void run(String... args) {
        allCollect();
    }

}
