package org.matrix.actuators.usecase;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 * 当用户执行了一组测试用例后，会返回这个对象
 * @author huangxiahao
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class TestCaseReport extends BaseTime{

    private Long caseId;

    /**
     * 执行状态
     */
    private Boolean status;

    /**
     * case下的每一个执行结果
     */
    private List<TestDataExecuteResult> dataExecuteResults = new ArrayList<>();

    public TestCaseReport(LocalDateTime startTime, LocalDateTime endTime, Long caseId, Boolean status, List<TestDataExecuteResult> dataExecuteResults) {
        super(startTime, endTime);
        this.caseId = caseId;
        this.status = status;
        this.dataExecuteResults = dataExecuteResults;
    }
}
