package org.matrix.database.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.matrix.database.entity.Action;
import org.matrix.database.mapper.ActionMapper;
import org.matrix.database.service.IActionService;
import org.springframework.stereotype.Service;

import java.util.Optional;

/**
 * <p>
 * 动作 服务实现类
 * </p>
 *
 * @author matrix
 * @since 2022-01-15
 */
@Service
public class ActionServiceImpl extends ServiceImpl<ActionMapper, Action> implements IActionService {

    private final ActionMapper actionMapper;

    public ActionServiceImpl(ActionMapper mapper) {
        this.actionMapper = mapper;
    }

    @Override
    public Optional<Action> findByMoveAndEnv(Long moveId, Long envId) {
        LambdaQueryWrapper<Action> actionWrappers = Wrappers.lambdaQuery(Action.class);
        Action action = actionMapper.selectOne(actionWrappers
                .eq(Action::getMoveId, moveId)
                .eq(Action::getEnvId, envId));
        return Optional.ofNullable(action);
    }
}
