package org.matrix.testNg.web.report;

import org.matrix.testNg.utils.Duration;
import org.matrix.testNg.utils.SecToTime;
import org.matrix.testNg.web.entity.DataBean;
import org.matrix.testNg.web.entity.DataBeans;
import org.matrix.testNg.web.entity.DataMove;
import org.matrix.testNg.web.vo.DataBeansVo;
import org.matrix.util.ReporterUtils;

import java.util.List;

/**
 * @author mruny
 */
public class ReporterData {

    /**
     * 模板公共部分
     *
     * @return 补全了的所有报告信息
     */
    public DataBean testDataBean() {
        DataBeansVo dataBeansVo = ReporterUtils.map.get("dataBeansVo");
        int passNum = 0;
        int failNum = 0;
        Long oneTime = 0L;
        // 测试结果汇总数据
        DataBean dataBean = dataBeansVo.getDataBean();
        List<DataBeans> dataBeanLists = dataBeansVo.getDataBeanLists();
        for (DataBeans dataBeanList : dataBeanLists) {
            Long duration = dataBeanList.getDuration();
            oneTime = oneTime + duration;
            if (dataBeanList.getResult()) {
                passNum += 1;
            } else {
                failNum += 1;
            }
        }
        //成功
        dataBean.setPassNum(passNum);
        //失败
        dataBean.setFailNum(failNum);
        //总数
        dataBean.setTotal(passNum + failNum);
        //通过率
        dataBean.setProbability(passNum / (passNum + failNum));
        Duration duration = SecToTime.secToTime(oneTime);
        Integer hour = duration.getHour();
        Integer minute = duration.getMinute();
        Integer second = duration.getSecond();
        String allTime = hour + "." + minute + "." + second;
        dataBean.setAllTime(allTime);
        return dataBean;
    }

    /**
     * 动作部分
     */
    public DataMove testDataBeanMove() {
        return ReporterUtils.map.get("dataBeansVo").getDataMove();
    }

    /**
     * 模板的细节部分
     *
     * @return 报告中细节部分的信息
     */
    public List<DataBeans> testDataBeans() {
        return ReporterUtils.map.get("dataBeansVo").getDataBeanLists();
    }

}