package org.matrix.testNg.web.report;

import org.matrix.testNg.utils.Duration;
import org.matrix.testNg.utils.SecToTime;
import org.matrix.testNg.web.entity.DataBean;
import org.matrix.testNg.web.entity.DataBeans;
import org.matrix.testNg.web.entity.DataMove;
import org.matrix.testNg.web.vo.DataBeansJobVo;
import org.matrix.testNg.web.vo.DataBeansMoveVo;
import org.matrix.util.ReporterUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * @author MRY
 */
public class ReporterDataJob {
    /**
     * 模板公共部分
     *
     * @return 补全了的所有报告信息
     */
    public DataBean testDataBean() {
        DataBeansJobVo dataBeansJobVo = ReporterUtils.jobMap.get("job");
        int passNum = 0;
        int failNum = 0;
        Long oneTime = 0L;
        // 测试结果汇总数据
        DataBean dataBean = dataBeansJobVo.getDataBean();
        List<DataBeansMoveVo> dataBeansMoveVos = dataBeansJobVo.getDataBeansMove();
        for (DataBeansMoveVo dataBeansMoveVo : dataBeansMoveVos) {
            List<DataBeans> dataBeansList = dataBeansMoveVo.getDataBeansList();
            for (DataBeans dataBeans : dataBeansList) {
                Long duration = dataBeans.getDuration();
                oneTime = oneTime + duration;
                if (dataBeans.getResult()) {
                    passNum += 1;
                } else {
                    failNum += 1;
                }
            }
        }
        //成功
        dataBean.setPassNum(passNum);
        //失败
        dataBean.setFailNum(failNum);
        //总数
        dataBean.setTotal(passNum + failNum);
        //通过率
        dataBean.setProbability(passNum / (passNum + failNum));
        Duration duration = SecToTime.secToTime(oneTime);
        Integer hour = duration.getHour();
        Integer minute = duration.getMinute();
        Integer second = duration.getSecond();
        String allTime = hour + "." + minute + "." + second;
        dataBean.setAllTime(allTime);
        return dataBean;
    }

    /**
     * 动作部分
     */
    public List<DataMove> testDataBeanMove() {
        List<DataMove> dataMoveList = new ArrayList<>();
        List<DataBeansMoveVo> dataBeansMoveVos = ReporterUtils.jobMap.get("job").getDataBeansMove();
        for (DataBeansMoveVo dataBeansMoveVo : dataBeansMoveVos) {
            DataMove dataMove = dataBeansMoveVo.getDataMove();
            dataMoveList.add(dataMove);
        }
        return dataMoveList;
    }

    /**
     * 模板的细节部分
     *
     * @return 报告中细节部分的信息
     */
    public List<DataBeans> testDataBeans() {
        List<DataBeans> dataBeansList = null;
        List<DataBeansMoveVo> dataBeansMoveVos = ReporterUtils.jobMap.get("job").getDataBeansMove();
        for (DataBeansMoveVo dataBeansMoveVo : dataBeansMoveVos) {
            dataBeansList = dataBeansMoveVo.getDataBeansList();
        }
        return dataBeansList;
    }
}
