package org.matrix.autotest.service.Impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.matrix.autotest.dao.TestCaseMapper;
import org.matrix.autotest.entity.TestCase;
import org.matrix.autotest.service.TestCaseService;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author mry
 * @since 2022-01-07
 */
@Service
public class TestCaseServiceImpl extends ServiceImpl<TestCaseMapper, TestCase> implements TestCaseService {

    private final TestCaseMapper testCaseMapper;

    public TestCaseServiceImpl(TestCaseMapper testCaseMapper) {
        this.testCaseMapper = testCaseMapper;
    }

    @Override
    public List<TestCase> findAllTestCase() {
        return testCaseMapper.selectList(null);
    }

    @Override
    public TestCase findByIdTestCase(Integer id) {
        return testCaseMapper.selectById(id);
    }

    @Override
    public int insertTestCase(TestCase testCase) {
        return testCaseMapper.insert(testCase);
    }

    @Override
    public int updateTestCase(TestCase testCase) {
        return testCaseMapper.updateById(testCase);
    }

    @Override
    public int deleteTestCase(Integer id) {
        return testCaseMapper.deleteById(id);
    }

    @Override
    public List<TestCase> findByProjectIdTestCase(Integer projectId) {
        QueryWrapper<TestCase> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("project_id", projectId);
        return testCaseMapper.selectList(queryWrapper);
    }

}
