package org.matrix.autotest.service;

import com.baomidou.mybatisplus.extension.service.IService;
import org.matrix.autotest.entity.Project;

import java.util.List;

/**
 * <p>
 * 服务类
 * </p>
 *
 * @author mry
 * @since 2022-01-07
 */
public interface ProjectService extends IService<Project> {
    /**
     * 查询所有项目
     *
     * @return 查询到的所有项目
     */
    List<Project> findAllProject();

    /**
     * 根据id查询项目
     *
     * @param id 项目id
     * @return 项目
     */
    Project findByIdProject(Integer id);

    /**
     * 添加项目
     *
     * @param project 项目
     * @return 影响行数
     */
    int insertProject(Project project);

    /**
     * 修改项目
     *
     * @param project 项目
     * @return 影响行数
     */
    int updateProject(Project project);

    /**
     * 删除项目
     *
     * @param id 项目id
     * @return 影响行数
     */
    int deleteProject(Integer id);

}
