package org.matrix.autotest.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <p>
 * 动作
 * </p>
 *
 * @author mry
 * @since 2022-01-07
 */
@Data
@Accessors(chain = true)
@ApiModel(value = "动作表")
@TableName(value = "action")
public class Action {

    private static final long serialVersionUID = 1L;

    /**
     * ID
     */
    @ApiModelProperty(value = "ID")
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 名称
     */
    @ApiModelProperty(value = "名称")
    private String name;

    /**
     * 行为ID
     */
    @ApiModelProperty(value = "行为ID")
    private Integer moveId;

    /**
     * 项目ID
     */
    @ApiModelProperty(value = "项目ID")
    private Integer projectId;

    /**
     * 备注
     */
    @ApiModelProperty(value = "备注")
    private String remark;

    /**
     * 类型 1为SQL，2为HTTP，3为CASE，4为WAIT_TIME
     */
    @ApiModelProperty(value = "类型 1为SQL，2为HTTP，3为CASE，4为WAIT_TIME")
    private Integer type;

    /**
     * 详细参数
     */
    @ApiModelProperty(value = "详细参数")
    private String detail;

    /**
     * 实例
     */
    @ApiModelProperty(value = "实例")
    private String env;

    @ApiModelProperty(value = "添加时间")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "更新时间")
    private LocalDateTime updateTime;


}
