package org.matrix.autotest.service;

import com.baomidou.mybatisplus.extension.service.IService;
import org.matrix.autotest.entity.Action;
import org.matrix.autotest.entity.Move;

import java.util.List;

/**
 * <p>
 * 动作 服务类
 * </p>
 *
 * @author mry
 * @since 2022-01-07
 */
public interface ActionService extends IService<Action> {

    /**
     * 查询所有动作
     *
     * @return 查询到的所有动作
     */
    List<Action> findAllAction();

    /**
     * 根据id查询动作
     *
     * @param id 动作id
     * @return 动作
     */
    Action findByIdAction(Integer id);

    /**
     * 添加动作
     *
     * @param action 动作
     * @return 影响行数
     */
    int insertAction(Action action);

    /**
     * 修改动作
     *
     * @param action 动作
     * @return 影响行数
     */
    int updateAction(Action action);

    /**
     * 删除动作
     *
     * @param id 动作id
     * @return 影响行数
     */
    int deleteAction(Integer id);

    /**
     * 根据项目id查询动作
     *
     * @param projectId 项目id
     * @return 符合项目id的动作
     */
    List<Action> findByProjectIdAction(Integer projectId);

    /**
     * 根据行为id查询动作
     *
     * @param moveId 行为id
     * @return 符合行为id的动作
     */
    List<Action> findByMoveIdAction(Integer moveId);

}
