package org.matrix.database.service;

import com.baomidou.mybatisplus.extension.service.IService;
import org.matrix.database.entity.ExecutionRecord;
import org.matrix.enums.ExecutionRecType;
import org.matrix.socket.vo.TestExecuteLog;

/**
 * @author mry
 */
public interface IExecutionRecordService extends IService<ExecutionRecord> {

    /**
     * 根据List<ExecutionRecord>，拼接出前端能够使用的数据结构
     * 出参示例：
     *         {
     *             -1:{
     *                 2:{
     *                     2:[
     *                          "张三","赵四"
     *                     ]
     *                 }
     *             }
     *         }
     */


    /**
     * 新增执行记录日志
     * @param testExecuteLog 用例日志临时存储对象
     * @param log 日志内容
     * @return 刚才新增的东西
     */
    ExecutionRecord addExecutionRecord(TestExecuteLog testExecuteLog,String log);

    /**
     * 根据uniqueKey将对应的执行记录修改为目标状态
     * @param uniqueKey 类似于批次Id的作用，同一批执行拥有相同uniqueKey
     * @param status 目标状态
     */
    void setStatusByUniqueKey(String uniqueKey, ExecutionRecType status);
}
