package org.matrix.database.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.matrix.database.entity.Environment;
import org.matrix.database.mapper.EnvironmentMapper;
import org.matrix.database.service.IEnvironmentService;
import org.springframework.stereotype.Service;

import java.util.Optional;

/**
 * <p>
 * 实例表，项目对应的环境实例，例如：实验室环境，开发环境等 服务实现类
 * </p>
 *
 * @author matrix
 * @since 2022-01-15
 */
@Service
public class EnvironmentServiceImpl extends ServiceImpl<EnvironmentMapper, Environment> implements IEnvironmentService {

    @Override
    public Boolean setIsDefaultByWrapper(Boolean isDefault, Wrapper wrappers) {
        Environment environment = new Environment();
        environment.setIsDefault(isDefault);
        return Optional.of(this
                .update(environment,wrappers)).get();
    }
}
