package org.matrix.local.exception;

import com.google.common.collect.ImmutableMap;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

@ControllerAdvice
public class ExceptionHandle {

    @ExceptionHandler(RuntimeException.class)
    public ResponseEntity handle(RuntimeException exception) {
        return ResponseEntity.ok(ImmutableMap.of("message", exception.getMessage()));
    }

}
