package org.matrix.entity.httpRequest;

import org.springframework.lang.Nullable;

import java.util.HashMap;
import java.util.Map;

/**
 * @author huangxiahao
 */
public enum HttpRequestType {

    /**
     * 通过将变量拼接在url中的方式请求，例如：127.0.0.1?a=1&b=2
     */
    QUERY,

    /**
     * 通过FORM_DATA的方式发起请求
     */
    FORM_DATA,

    /**
     * 通过X_WWW_FORM_URLENCODED的方式发起请求
     */
    X_WWW_FORM_URLENCODED,

    /**
     * 通过TEXT发起请求
     */
    TEXT,

    /**
     * 通过JSON发起请求
     */
    JSON,

    /**
     * 通过XML发起请求
     */
    XML,

    /**
     * 通过BINARY发起请求
     */
    BINARY,

    /**
     * 无任何请求方式，空实现
     */
    NONE;

    private static final Map<String, HttpRequestType> MAPPINGS = new HashMap<>(16);


    @Nullable
    public static HttpRequestType resolve(@Nullable String method) {
        return method != null ? MAPPINGS.get(method) : null;
    }

    public boolean matches(String method) {
        return this.name().equals(method);
    }

    static {
        HttpRequestType[] var0 = values();
        int var1 = var0.length;
        for (HttpRequestType httpMethod : var0) {
            MAPPINGS.put(httpMethod.name(), httpMethod);
        }

    }
}
