package org.matrix.database.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.matrix.database.entity.TestCase;
import org.matrix.database.mapper.TestCaseMapper;
import org.matrix.database.service.ITestCaseService;
import org.matrix.database.vo.PageResult;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.util.List;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author matrix
 * @since 2022-01-15
 */
@Service
public class TestCaseServiceImpl extends ServiceImpl<TestCaseMapper, TestCase> implements ITestCaseService {

    private final TestCaseMapper testCaseMapper;

    public TestCaseServiceImpl(TestCaseMapper testCaseMapper) {
        this.testCaseMapper = testCaseMapper;
    }

    @Override
    public int insertTestCase(TestCase testCase) {
        return testCaseMapper.insert(testCase);
    }

    @Override
    public int updateTestCase(TestCase testCase) {
        return testCaseMapper.updateById(testCase);
    }

    @Override
    public int deleteTestCase(Integer id) {
        return testCaseMapper.deleteById(id);
    }

    @Override
    public List<TestCase> findByProjectIdTestCase(Integer projectId) {
        QueryWrapper<TestCase> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("project_id", projectId);
        return testCaseMapper.selectList(queryWrapper);
    }

    @Override
    public PageResult pageAll(PageResult pageResult) {
        IPage ipage = new Page(pageResult.getPageNum(), pageResult.getPageSize());
        QueryWrapper queryWrapper = new QueryWrapper();
        boolean flage = StringUtils.hasLength(pageResult.getQuery());
        queryWrapper.like(flage, "name", pageResult.getQuery());
        //执行分页查询，返回值依然是分页的对象
        ipage = testCaseMapper.selectPage(ipage, queryWrapper);
        long total = ipage.getTotal();
        List<TestCase> rows = ipage.getRecords();
        //回传5个参数 total/分页后的数据
        return pageResult.setTotal(total).setRows(rows);
    }

}
