package org.matrix.config;

import org.matrix.socket.ExecutionSocketHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.socket.config.annotation.EnableWebSocket;
import org.springframework.web.socket.config.annotation.WebSocketConfigurer;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistry;

/**
 * @author huangxiahao
 */
@Configuration
@EnableWebSocket
public class WebSocketConfig implements WebSocketConfigurer {

    private final ExecutionSocketHandler executionSocketHandler;

    public WebSocketConfig(ExecutionSocketHandler executionSocketHandler) {
        this.executionSocketHandler = executionSocketHandler;
    }

    @Override
    public void registerWebSocketHandlers(WebSocketHandlerRegistry registry) {
        registry
                .addHandler(executionSocketHandler, "ws")
                .setAllowedOrigins("*");
    }
}