package org.matrix.database.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * Swagger中的接口信息
 *
 * @author mry
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "接口信息")
public class InterfaceInformation {

    /**
     * ip 以及端口信息
     */
    @ApiModelProperty(value = "ip以及端口信息")
    private String host;

    /**
     * /
     */
    @ApiModelProperty(value = "/")
    private String basePath;

    /**
     * 请求方式
     */
    @ApiModelProperty(value = "请求方式")
    private String request;

    /**
     * 标签
     */
    @ApiModelProperty(value = "标签")
    private String tags;

    /**
     * 总结
     */
    @ApiModelProperty(value = "总结")
    private String summary;

    /**
     * 方法拼接的url
     */
    @ApiModelProperty(value = "方法拼接的url")
    private String methodUrl;

    /**
     * 参数
     */
    @ApiModelProperty(value = "参数")
    private List<Parameter> parameterAllList;


}
