package org.matrix.database.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Select;
import org.matrix.database.entity.ExecutionHistory;
import org.matrix.database.vo.ExecutionHistoryVo;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * <p>
 * Mapper 接口
 * </p>
 *
 * @author mry
 * @since 2022-03-11
 */
@Repository
public interface ExecutionHistoryMapper extends BaseMapper<ExecutionHistory> {

    /**
     * 根据CaseId和JobId 查询对应的数据列表
     * @param page 分页数据
     * @param jobId 测试任务ID
     * @param caseId 用例ID
     * @param userId 用户ID
     * @return 执行记录列表
     */
    @Select("<script>" +
            "SELECT\n" +
            "\tkeh.id,\n" +
            "\tkeh.union_key unionKey,\n" +
            "\tkeh.case_id caseId,\n" +
            "\tkeh.data_id dataId,\n" +
            "\tkeh.job_id jobId,\n" +
            "\tIF(MIN( keh.`status` )= 0 or MIN( keh.`status` ) = 1,1,MAX(keh.`status`)) `status`,\n" +
            "\tktc.`name` caseName,\n" +
            "\tktd.`name` dataName," +
            "\tMIN(keh.create_time) startTime,\n" +
            "\tMAX(keh.update_time) endTime " +
            "FROM\n" +
            "\tkt_execution_history keh\n" +
            "\tLEFT JOIN kt_test_case ktc ON ktc.id = keh.case_id\n" +
            "\tLEFT JOIN kt_test_data ktd ON ktd.id = keh.data_id" +
            "<where>" +
            "<if test=\"userId!=null\">\n" +
            "and keh.user_id= #{userId} \n" +
            " </if>" +
            "<if test=\"caseId!=null\">\n" +
            "and keh.case_id= #{caseId} \n" +
            " </if>" +
            "<if test=\"jobId!=null\">\n" +
            "and keh.job_id= #{jobId} \n" +
            " </if>" +
            "</where>" +
            "GROUP BY keh.union_key " +
            "</script>")
    IPage<ExecutionHistoryVo> pageByCaseIdAndJobId(IPage<ExecutionHistoryVo> page, Long caseId, Long jobId,Long userId);

    /**
     * 查出最近一条的执行历史
     * @param jobId 测试任务ID
     * @param caseId 用例ID
     * @param userId 用户ID
     * @return 执行记录列表
     */
    @Select("<script>" +
            "SELECT\n" +
            "\tkeh.id,\n" +
            "\tkeh.union_key unionKey,\n" +
            "\tkeh.case_id caseId,\n" +
            "\tkeh.data_id dataId,\n" +
            "\tkeh.job_id jobId,\n" +
            "IF\n" +
            "\t(\n" +
            "\tMIN( keh.`status` )= 0 or MIN( keh.`status` ) = 1,\n" +
            "\t1,\n" +
            "\tMAX( keh.`status` )) `status`,\n" +
            "\tktc.`name` caseName,\n" +
            "\tktd.`name` dataName,\n" +
            "\tMIN( keh.create_time ) startTime,\n" +
            "\tMAX( keh.update_time ) endTime \n" +
            "FROM\n" +
            "\tkt_execution_history keh\n" +
            "\tLEFT JOIN kt_test_case ktc ON ktc.id = keh.case_id\n" +
            "\tLEFT JOIN kt_test_data ktd ON ktd.id = keh.data_id \n" +
            "\t WHERE keh.union_key = ( SELECT union_key FROM kt_execution_history WHERE id IN ( SELECT max( id ) FROM kt_execution_history " +
            "<where>" +
            "<if test=\"userId!=null\">\n" +
            "and user_id= #{userId} \n" +
            " </if>" +
            "<if test=\"caseId!=null\">\n" +
            "and case_id= #{caseId} \n" +
            " </if>" +
            "<if test=\"jobId!=null\">\n" +
            "and job_id= #{jobId} \n" +
            " </if>" +
            "</where>" +
            "GROUP BY case_id ) ) \n" +
            "GROUP BY\n" +
            "\tkeh.union_key\n" +
            "</script>")
    ExecutionHistoryVo selectLastExecutionHistoryVo( Long caseId, Long jobId,Long userId);

}
