package org.matrix.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 执行历史中的执行状态
 * @author huangxiahao
 */

@Getter
@AllArgsConstructor
public enum ExecutionHistoryStatus {

    /**
     * 准备阶段
     */
    READY(0, "准备阶段"),
    /**
     * 执行阶段
     */
    RUN(1, "执行阶段"),
    /**
     * 完成阶段
     */
    FINISH(2, "完成阶段"),
    /**
     * 异常
     */
    ERROR(3, "异常");

    /**
     * 数据库里记录的字段使用该字段来记录
     */
    @EnumValue
    private final int code;

    private final String des;
}
