package org.matrix.socket.pool;

import org.springframework.web.socket.WebSocketSession;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

/**
 * 订阅执行日志的池子
 *
 * @author huangxiahao
 */
public class ExecuteMonitorSocketPool {

    /**
     * unionKey -> socket队列
     * key为unionKey value 为 socket队列
     */
    private static final ConcurrentHashMap<String, List<WebSocketSession>> SOCKET_MAP = new ConcurrentHashMap<>();

    /**
     * socketId -> unionKey队列
     * key为socketId value 为 unionKey队列
     */
    private static final ConcurrentHashMap<String, List<String>> SOCKET_KEY_MAP = new ConcurrentHashMap<>();

    public static void add(String key, WebSocketSession clientSocket) {
        if (clientSocket != null & key != null) {
            List<WebSocketSession> webSocketSessions = SOCKET_MAP.get(key);
            if (webSocketSessions != null) {
                webSocketSessions.add(clientSocket);
            } else {
                webSocketSessions = new ArrayList<>();
                webSocketSessions.add(clientSocket);
                SOCKET_MAP.put(key, webSocketSessions);
            }
            addKeyMap(clientSocket.getId(), key);
        }
    }

    public static void addKeyMap(String socketId, String key) {
        if (socketId != null & key != null) {
            List<String> list = SOCKET_KEY_MAP.get(socketId);
            if (list != null) {
                list.add(key);
            } else {
                list = new ArrayList<>();
                list.add(key);
                SOCKET_KEY_MAP.put(socketId, list);
            }
        }
    }

    public static void remove(WebSocketSession clientSocket) {
        String socketId = clientSocket.getId();
        List<String> list = SOCKET_KEY_MAP.get(socketId);
        if (list != null) {
            for (String s : list) {
                SOCKET_MAP.get(s).remove(clientSocket);
            }
        }
        SOCKET_KEY_MAP.remove(socketId);

    }

    public static List<WebSocketSession> get(String key) {
        return SOCKET_MAP.get(key);
    }
}