package org.matrix.testNg.report;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * @author mruny
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class DataBean {

    /**
     * 未执行的test数量
     */
    private int excludeTestsSize;

    /**
     * 测试通过的数量
     */
    private int passedTestsSize;

    /**
     * 测试失败的数量
     */
    private int failedTestsSize;

    /**
     * 测试跳过的数量
     */
    private int skippedTestsSize;

    /**
     * 全部执行的测试的数量
     */
    private int allTestsSize;

//    /**
//     * 全部执行的测试方法
//     */
//    private ITestNGMethod[] allTestsMethod;

//    /**
//     * 未执行的测试方法
//     */
//    private Collection<ITestNGMethod> excludeTestsMethod;

    /**
     * 测试耗时
     */
    private String testsTime;

    /**
     * 测试通过率
     */
    private String passPercent;

    /**
     * 单个测试周期
     */
    private String duration;

    /**
     * 测试用参数
     */
    private String params;

    /**
     * 测试描述
     */
    private String des;

    /**
     * Reporter Output
     */
    private List<String> output;

    /**
     * 测试依赖方法
     */
    private String dependMethod;

    /**
     * 测试异常原因
     */
    private Throwable throwable;

    /**
     * 异常堆栈信息
     */
    private StackTraceElement[] stackTrace;

    /**
     * 结果信息
     */
    private String resultMessage;

    /**
     * 用例名称
     */
    private String testCaseName;

    /**
     * 用例类型
     */
    private String type;

    /**
     * 前置行动ID组，例如：1，2，3
     */
    private String moveBefore;

    /**
     * 后置行动ID组，例如：1，2，3
     */
    private String moveAfterCase;

    /**
     * 测试执行后行动ID组，例如：1，2，3
     */
    private String moveAfterTest;

    /**
     * 是否进行异常检验,0为否,1为是
     */
    private Integer abnormalCheckpoint = 0;

    /**
     * 是否进行非空检验,0为否,1为是
     */
    private Integer noEmptyCheckpoint = 0;

    /**
     * 包含某字段检验（例如 张三,李四） 则对检查结果中是否包含张三或者李四
     */
    private String containCheckpoint;

    /**
     * 不包含某字段检验（例如 张三,李四） 则对检查结果中是否不包含张三或者李四
     */
    private String noContainCheckpoint;

    /**
     * 数据库检验点，以JSON形式存放
     */
    private String databaseCheckpoint;

    /**
     * jsonpath检验点，以json形式存放
     */
    private String jsonpathCheckpoint;

    /**
     * 详情参数
     */
    private String detail;


}