# TY - KeyStone 自动化测试平台

## 参考与设计
![image1.png](https://cdn.nlark.com/yuque/0/2022/png/2791403/1641545529717-02a8541e-d54c-4718-9fdb-73b4a05e8854.png#clientId=ub43f43b2-d5aa-4&crop=0&crop=0&crop=1&crop=1&id=QKD9H&name=image.png&originHeight=1125&originWidth=2000&originalType=binary&ratio=1&rotation=0&showTitle=false&size=614893&status=done&style=none&taskId=u748fa8f2-ae62-4082-9875-b5eb3cc9153&title=)
![image2.png](https://cdn.nlark.com/yuque/0/2022/png/2791403/1641545535867-baa9f9fa-3c02-4312-8c92-921ea446ff70.png#clientId=ub43f43b2-d5aa-4&crop=0&crop=0&crop=1&crop=1&id=bJITj&name=image.png&originHeight=1128&originWidth=1200&originalType=binary&ratio=1&rotation=0&showTitle=false&size=425724&status=done&style=none&taskId=u22d72b85-18fb-4215-95c0-65ce5c6f6ce&title=)
![image3.png](https://cdn.nlark.com/yuque/0/2022/png/2791403/1641455205422-c60b9707-0577-49f1-a8c0-d188afb0174a.png#clientId=uda5b283b-aad6-4&crop=0&crop=0&crop=1&crop=1&from=paste&id=SDeFj&margin=%5Bobject%20Object%5D&name=image.png&originHeight=1260&originWidth=1200&originalType=binary&ratio=1&rotation=0&showTitle=false&size=449749&status=done&style=none&taskId=u29004590-b729-4828-a3ca-2b8b97d00ef&title=)

- 放在base包中，引入之后读取application-name,设置当前环境名

关于用例表的字段设计

- id
- 团队(项目) - 结合禅道的团队表设计 - 通过读取DB的方式获取到
- 服务名与环境名通过base来获得
- 接口名与基本信息通过swagger获得
- 参数，参数类型，参数值
    - 动态参数列表
### 术语与定义

- 项目表，用例表，连接池表，实例表，行为表，动作表，动态变量表
- move - 行为，用例绑定的是行为，行为依据实例的不同来决定具体执行的动作 ,  动作与用例都是保存的结构，结构要运行需要实际执行参数(动态变量表,连接池表)
- action - 行为保存的是定义，动作action才是实际的执行逻辑，例如一段登录行为，可能依据实际环境的不同实际执行的动作是不一样的(例如有的环境下是微信登录，有的环境下其他登录)
## 计划

- 第一阶段 6周  年前可以完成至少80% - 能够自动读取swagger接口并让使用者在不编写代码的情况下能够对接口编写测试用例
    - 参数是能够做到动态替换的，即测试用例与测试数据是分离的
    - 结果是可以做到结构化解析的
    - 测试完毕之后会提供测试报告
    - 参数替换，测试执行，结果校验
- 第二阶段 4周
    - 增加与jenkins的融合，使得自动测试用例可以自动触发，通过jenkins脚本触发等
    - 前置动作，测试后动作，后置动作
    - 测试报告生成
- 第三阶段 4周
    - 增加代码覆盖率的统计，测试结果总集的监控汇总信息
    - 增加与禅道的融合，会读取禅道的二次开发接口获得禅道里面的关于团队和项目的数据，并将测试结果反推给禅道
    - 增加报表导出
    - 用例得分评估
## 执行流程

- TESTNG 脚本启动器 - 通过TESTNG的XML脚本读取本次需要批量执行的测试用例
- 用例执行器执行
    - 前置动作
    - 执行http用例请求 - 过程中实时计算出变量
    - 执行后动作
    - 校验器
    - 校验后动作
- 统计/评分/报表
## 执行器

- [ ] 用例执行器
- [ ] 行为执行器
- [ ] 变量执行器
- [ ] 校验器

测试用例的执行方式

- [x] HTTP 调用
- [ ] RPC 调用
- [ ] Java方法调用
## 动态参数
参数类型

- 固定值
- 调用SQL - 可能会出现  `select * from user where user.id = #{id} and user.name = ${name}`
- HTTP -
- 调用用例
## 前后置动作
前后置动作类型

1. SQL类型动作，返回结果是 `List<Map<String,Object`
1. HTTP类型动作，返回结果是 pre.1.http/case.statusCode
1. 用例类型动作，返回值是  pre1.http.reponse/body/code.time
1. 等待类动作，没有返回值可以拿
## 动态数值计算

- [ ] 常量
- [x] SQL表达式
- [x] HTTP请求结果
- [ ] 测试用例结果
- [ ] DSL计算
- [ ] 本地实现

测试结果

- 测试用例运行成功/失败
- 测试结果自定义返回值
- 测试报告返回值
### 现有语法

- 动态变量 `${id}[0]`
- 动作 `${pre.1.name}[0]`
- 结果集 `{$.data[0]}[0]`
- 环境数值 `#{name}`
### SQL执行器对外暴露的接口
```java
/**

*/
public String runSql(String sql,Long envId);
```
### SQL替换
```json
findDynamicVarList -> 分离出变量名与下标
parseVarByName("$name[1]") - 附带了 name 与 index0
解析 name -> runsql 下标使用index0 , 发现ip
递归解析 ip -> 下标是新解析出来的


```
```json
{
	"poolId" : 15,
    "sqlExp" : "select * from user where user.id = 1"
    componentName[2]
}

{"poolId":1,"sqlExp":"select * from component where ip = ${ip}"} -> ..

{"poolId":2,"sqlExp":"select * from example"} => 127.0.0.1 

```

动态的执行SQL并保存运行结果，对于频繁的调用，直接调用JDBC显然是不行的，同时数据源是需要动态切换的，也就是动态切换多数据源的连接池，基本原理是以AOP拦截的方式动态切换datasource<br />在base包中，会读取主库的表得到一系列数据源连接的参数，script包中会引入base中，如果script包中设置了数据源，那么base包会读取script包下的数据源作为主数据源。<br />可不可以做到如果script填了数据源就连接script的数据源，否则就使用base包提供的数据源呢？有点类似于springboot的自动装配机制<br />具体思路是在base中提供一个自动装配的数据源，默认连接到测试用例库的位置
#### @EnableConfigurationProperties
使得`@configurationProperties`注解的类注册为bean,等效于在该类上`@component`以及直接在配置类里的`@Bean`中使用`@ConfigurationProperties`注解
### 修好的BUG

- mapper扫描问题
- 枚举的选用问题

## 第二阶段
### 2-1

- 新增接口概念，重新设计接口,用例,执行器页面
- 增加用例与执行的调试，运行部分
- 实装动作/行为模块
- 增加用户系统与项目系统，增加与禅道的连接，读取禅道的用户系统与项目系统
- 新增TEST JOB 概念，即测试任务概念
## 记一下要解决的问题

- 数据量的预估
- 死循环调用
- 特殊的value值触发了相同语法
- 部分方法的线程安全问题
- 大规模运行效率的优化问题
- 各类变量池的界定与隔离
- 数据库下标
- 详细的执行日志
## 演示脚本
#### 痛点

- 需求接口变动后，需要重新编写测试用例，可能新写一个需求10分钟，写一个测试要20分钟，而且一天后就失效了
- 写好的测试用例太死板，遇到环境变动/数据库切换，以及大量的不确定值的时候显得非常无力
- 高质量自动化测试难度高，但是很多人不知道从何做起，同时维护难度也高，非专业测试人员几乎没法去维护测试用例
- 测试用例的执行非常死板，可能是用java/postman写好的，脚本之间无法互相共享也无法进行定制化的执行

简单来说就是一个测试用例编写花费的时间过长，同时生效的范围和作用太小，得不偿失，无法持续下去。<br />**解决痛点的两个方面**

- 减少成本
    - **减少用例录入成本。**简化测试用例录入的成本，尽可能多的提示，如果可以，开发一些批量生成测试用例的工具。
    - **减少用例维护成本。**减少用例维护成本，尽量只用在页面上做简单的输入即可完成维护动作，而不是进行大量的代码操作。
    - **减少用例优化成本。**当团队做用例优化时，可以通过一些统计数据，进行有针对性、有目的性的用例优化。
- 增加使用率
    - **手工也能用。**不只是进行接口自动化测试，也可以完全用在手工测试上。
    - **人人能用。**每一个需要使用测试的人，包括一些非技术人员都可以使用。
    - **当工具用。**将一些接口用例当成工具使用，比如“生成订单”工具，“查找表单数据”工具。
    - **每天测试。**进行每日构建测试。
    - **开发的在构建之后也能触发测试。**开发将被测系统构建后，能自动触发接口自动化测试脚本，进行测试。
#### 解决痛点（自动化接口测试平台的三个阶段）
**第一阶段**

- 递归解析并替换动态参数
- 测试用例结果集的语法动态解析与全输入模块的变量提示
- 提供可视化测试报告
- 提供在线配置使用(web) 与 离线 xml 配置的方式

**第二阶段**

- 实装前置/测试后/后置动作模块
- 美化丰富WEB页面，定制化测试报告模板，丰富测试用例的执行日志
- 增加WEB页面的在线调试部分，可以在线运行/调试测试用例，获得SQL/HTTP/测试用例运行结果
- 图形化测试用例调用链，监控链路节点的运行时间，日志
- 在运行前提供预检查器，可以在运行前提前检查出一些问题并报告
- 增加与jenkins的融合，使得平台的测试用例可以通过以JENKINS脚本的形式定制化触发

**第三阶段**

- WEB页面 加入语法提示，语法校验部分
- 增加代码覆盖率的统计，测试用例运行结果的统计
- 增加与禅道的融合，会读取禅道的二次开发接口获得禅道里面的关于团队和项目的数据，并将测试结果反推给禅道
- 增加项目内各类数据的报表导出
- 用例得分评估
#### 介绍功能与页面
**解决用例死板**

- 将测试脚本的结构与数据分离，使用MYSQL/数据库来保存测试用例，相比于比较流行的EXCEL驱动，保存在数据库里可以更加灵活的方便修改与迁移测试用例。
- 支持在线(WEB 平台) 与 离线(xml脚本)执行
- 无代码配置，引入即可使用

此处演示测试用例的列表，与XML启动的方式

#### <br />
#### 演示
#### 讲一些技术上的原理
#### 第二阶段与第三阶段

## 禅道相关

### 

### 测试用例(**zt_case**)

#### 数据表结构

| 序号 | 字段            | 描述           | 类型                       | 长度 | 是否可空 |
| :--- | :-------------- | :------------- | :------------------------- | :--- | :------- |
| 1    | id              | id             | int                        | 8    | NO       |
| 2    | project         | 所属项目       | int                        | 8    | NO       |
| 3    | product         | 所属产品       | int                        | 8    | NO       |
| 4    | execution       | 所属执行       | int                        | 8    | NO       |
| 5    | branch          | 分支/平台      | int                        | 8    | NO       |
| 6    | lib             | 所属库         | int                        | 8    | NO       |
| 7    | module          | 所属模块       | int                        | 8    | NO       |
| 8    | path            | 路径           | int                        | 8    | NO       |
| 9    | story           | 相关研发需求   | int                        | 30   | NO       |
| 10   | storyVersion    | 研发需求版本   | int                        | 6    | NO       |
| 11   | title           | 用例标题       | varchar                    | 255  | NO       |
| 12   | precondition    | 前置条件       | text                       |      | NO       |
| 13   | keywords        | 关键词         | varchar                    | 255  | NO       |
| 14   | pri             | 优先级         | int                        | 3    | NO       |
| 15   | type            | 用例类型       | char                       | 30   | NO       |
| 16   | auto            | 自动化测试用例 | varchar                    | 10   | NO       |
| 17   | frame           | 自动化测试框架 | varchar                    | 10   | NO       |
| 18   | stage           | 适用阶段       | varchar                    | 255  | NO       |
| 19   | howRun          | 测试方式       | varchar                    | 30   | NO       |
| 20   | scriptedBy      | 脚本由谁创建   | varchar                    | 30   | NO       |
| 21   | scriptedDate    | 脚本创建日期   | date                       |      | NO       |
| 22   | scriptStatus    | 脚本状态       | varchar                    | 30   | NO       |
| 23   | scriptLocation  | 脚本地址       | varchar                    | 255  | NO       |
| 24   | status          | 用例状态       | char                       | 30   | NO       |
| 25   | subStatus       | 子状态         | varchar                    | 30   | NO       |
| 26   | color           | 标题颜色       | char                       | 7    | NO       |
| 27   | frequency       | 使用频率       | enum('1','2','3')          |      | NO       |
| 28   | order           | 排序           | int                        | 30   | NO       |
| 29   | openedBy        | 由谁创建       | char                       | 30   | NO       |
| 30   | openedDate      | 创建日期       | datetime /* mariadb-5.3 */ |      | NO       |
| 31   | reviewedBy      | 由谁评审       | varchar                    | 255  | NO       |
| 32   | reviewedDate    | 评审时间       | date                       |      | NO       |
| 33   | lastEditedBy    | 最后修改者     | char                       | 30   | NO       |
| 34   | lastEditedDate  | 修改日期       | datetime /* mariadb-5.3 */ |      | NO       |
| 35   | version         | 用例版本       | int                        | 3    | NO       |
| 36   | linkCase        | 相关用例       | varchar                    | 255  | NO       |
| 37   | fromBug         | 来源Bug        | int                        | 8    | NO       |
| 38   | fromCaseID      | 用例来源ID     | int                        | 8    | NO       |
| 39   | fromCaseVersion | 用例来源版本   | int                        | 8    | NO       |
| 40   | deleted         | 是否删除       | enum('0','1')              |      | NO       |
| 41   | lastRunner      | 执行人         | varchar                    | 30   | NO       |
| 42   | lastRunDate     | 执行时间       | datetime /* mariadb-5.3 */ |      | NO       |
| 43   | lastRunResult   | 结果           | char                       | 30   | NO       |

#### 图片示例

![测试用例](docs/images/zentao/测试用例.png)

### 测试结果(**zt_testresult**)

#### 数据表结构

| 序号 | 字段        | 描述       | 类型                       | 长度 | 是否可空 |
| :--- | :---------- | :--------- | :------------------------- | :--- | :------- |
| 1    | id          | 编号       | int                        | 8    | NO       |
| 2    | run         | 执行编号   | int                        | 8    | NO       |
| 3    | case        | 用例       | int                        | 8    | NO       |
| 4    | version     | 版本       | int                        | 5    | NO       |
| 5    | job         | 构建任务   | int                        | 8    | NO       |
| 6    | compile     | 构建       | int                        | 8    | NO       |
| 7    | caseResult  | 测试结果   | char                       | 30   | NO       |
| 8    | stepResults | 步骤结果   | text                       |      | NO       |
| 9    | lastRunner  | 最后执行人 | varchar                    | 30   | NO       |
| 10   | date        | 测试时间   | datetime /* mariadb-5.3 */ |      | NO       |
| 11   | duration    | 持续时间   | float                      |      | NO       |
| 12   | xml         |            | text                       |      | NO       |

#### 图片示例

![测试结果](docs/images/zentao/测试结果.png)