package org.matrix.enums;

import com.fasterxml.jackson.annotation.JsonValue;
import lombok.AllArgsConstructor;

/**
 * ModuleType. 模块类型的枚举类 用于例如日志等模块
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2022/3/17 at 10:46 AM
 * Suffering is the most powerful teacher of life.
 */
@AllArgsConstructor
public enum ModuleType {

    /**
     * SQL执行器
     */
    SQL_ACTUATOR("SQL执行器"),
    /**
     * HTTP执行器
     */
    HTTP_ACTUATOR("HTTP执行器"),
    /**
     * 用例执行器
     */
    CASE_ACTUATOR("用例执行器"),
    /**
     * 动作执行器
     */
    MOVE_ACTUATOR("动作执行器"),
    /**
     * 变量解析器
     */
    VAR_PARSE("变量解析器"),

    /**
     * 语法解析器
     */
    SYNTAX_PARSE("语法解析器");

    /**
     * 模块名
     */
    private final String name;

    @JsonValue
    public String getName() {
        return name;
    }
}
