package org.matrix.database.controller;

import com.alibaba.fastjson.JSONObject;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

/**
 * TestController. 用于测试的控制器
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2022/1/21 at 4:53 PM
 * Suffering is the most powerful teacher of life.
 */
@RestController
@RequestMapping("/test")
public class TestController {


    /**
     * 获得表名,用于测试http执行器的调用
     */
    @GetMapping("/tableName")
    public ResponseEntity<String> getTableName(@RequestParam String tableName) {
        return ResponseEntity.ok(tableName);
    }

    @PostMapping("/sayHelloJson")
    public String sendMessage(@RequestBody Hello hello) {
        return String.format("{\n" +
                "    \"store\": {\n" +
                "        \"book\": [\n" +
                "            {\n" +
                "                \"category\": \"%s\",\n" +
                "                \"author\": \"Nigel Rees\",\n" +
                "                \"title\": \"Sayings of the Century\",\n" +
                "                \"price\": 8.95\n" +
                "            },\n" +
                "            {\n" +
                "                \"category\": \"fiction\",\n" +
                "                \"author\": \"Evelyn Waugh\",\n" +
                "                \"title\": \"Sword of Honour\",\n" +
                "                \"price\": 12.99\n" +
                "            },\n" +
                "            {\n" +
                "                \"category\": \"fiction\",\n" +
                "                \"author\": \"Herman Melville\",\n" +
                "                \"title\": \"Moby Dick\",\n" +
                "                \"isbn\": \"0-553-21311-3\",\n" +
                "                \"price\": 8.99\n" +
                "            },\n" +
                "            {\n" +
                "                \"category\": \"fiction\",\n" +
                "                \"author\": \"J. R. R. Tolkien\",\n" +
                "                \"title\": \"The Lord of the Rings\",\n" +
                "                \"isbn\": \"0-395-19395-8\",\n" +
                "                \"price\": 22.99\n" +
                "            }\n" +
                "        ],\n" +
                "        \"bicycle\": {\n" +
                "            \"color\": \"red\",\n" +
                "            \"price\": 19.95\n" +
                "        }\n" +
                "    },\n" +
                "    \"expensive\": 10\n" +
                "}", hello.getName());
    }

    @GetMapping("/sendMessage")
    public ResponseEntity sendMessage(String tableName) {
        JSONObject  jsonObject = new JSONObject();
        jsonObject.put("message",String.format("你好: %s",tableName));
        return ResponseEntity.ok(jsonObject);
    }
}
