package org.matrix.database.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * <p>
 * 动作
 * </p>
 *
 * @author matrix
 * @since 2022-01-15
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "Action对象", description = "动作")
public class Action extends BaseEntity {

    @ApiModelProperty("ID")
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty("名称")
    private String name;

    @ApiModelProperty("行为ID")
    private Integer moveId;

    @ApiModelProperty("项目ID")
    private Integer projectId;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("类型 1为SQL，2为HTTP，3为CASE，4为WAIT_TIME")
    private Integer type;

    @ApiModelProperty("详细参数")
    private String detail;


}
