package org.matrix.database.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import org.matrix.database.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import org.matrix.enums.DynamicVarType;

/**
 * <p>
 * 
 * </p>
 *
 * @author matrix
 * @since 2022-01-15
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@TableName("dynamic_variable")
@ApiModel(value = "DynamicVariable对象", description = "")
public class DynamicVariable extends BaseEntity {

    @ApiModelProperty("ID")
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty("所属项目")
    private Integer projectId;

    @ApiModelProperty("取用字段")
    private String takenField;

    @ApiModelProperty("名称")
    private String name;

    @ApiModelProperty("动态变量类型 1为KV，2为SQL，3为CASE，4为HTTP")
    private DynamicVarType type;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("详细内容")
    private String detail;


}
