package org.matrix.database.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import org.matrix.database.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;

/**
 * <p>
 * 实例表，项目对应的环境实例，例如：实验室环境，开发环境等
 * </p>
 *
 * @author matrix
 * @since 2022-01-15
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "Example对象", description = "实例表，项目对应的环境实例，例如：实验室环境，开发环境等")
public class Example extends BaseEntity {

    @ApiModelProperty("ID")
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty("实例名称")
    private String name;

    @ApiModelProperty("参数名 （例如：env）")
    private String parameterName;

    @ApiModelProperty("项目ID")
    private Integer projectId;

    @ApiModelProperty("静态变量，以JSON的形式存储，例如（{\"name\":\"张三\"}）")
    private String variable;

    @ApiModelProperty("ip,例如（http:www.abc.com）")
    private String ip;


}
