package org.matrix.testNg;

import java.sql.*;
import java.util.ArrayList;
import java.util.List;

/**
 * @author mry
 */
public class DataProviderForDb {

    static Connection connection;
    static ResultSet resultSet;
    static Statement statement;

    public static Object[][] getDb(String ip, String port, String baseName,
                                   String userName, String password, String sql) {
        List<Object[]> list = new ArrayList<>();
        String url = String.format("jdbc:mysql://%s:%s/%s", ip, port, baseName);
        try {
            Class.forName("com.mysql.cj.jdbc.Driver");
            connection = DriverManager.getConnection(url, userName, password);
            statement = connection.createStatement();
            resultSet = statement.executeQuery(sql);
            //声明存放泛型string数组的list对象
            int colNum = resultSet.getMetaData().getColumnCount();
            while (resultSet.next()) {
                String[] strings = new String[colNum];
                for (int i = 0; i < strings.length; i++) {
                    strings[i] = resultSet.getString(i + 1);
                }
                list.add(strings);
            }
        } catch (ClassNotFoundException | SQLException e) {
            e.printStackTrace();
        } finally {
            remove();
        }
        //将list对象转换成二维数组
        Object[][] results = new Object[list.size()][];
        for (int i = 0; i < list.size(); i++) {
            results[i] = list.get(i);
        }
        return results;
    }

    public static void remove() {
        try {
            if (resultSet != null) {
                resultSet.close();
            }
        } catch (SQLException e) {
            e.printStackTrace();
        }
        try {
            if (statement != null) {
                statement.close();
            }
        } catch (SQLException e) {
            e.printStackTrace();
        }
        try {
            if (connection != null) {
                connection.close();
            }
        } catch (SQLException e) {
            e.printStackTrace();
        }
    }

}