package org.matrix.database.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import org.matrix.actuators.datasource.DataSourceDTO;

/**
 * <p>
 *
 * </p>
 *
 * @author matrix
 * @since 2022-01-15
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "Connect对象", description = "数据库")
@TableName(value = "kt_connect")
public class Connect extends BaseEntity {

    @ApiModelProperty("名称")
    private String name;

    @ApiModelProperty("URL")
    private String url;

    @ApiModelProperty("账号")
    private String username;

    @ApiModelProperty("密码")
    private String password;

    @ApiModelProperty("所用驱动")
    private String driver;

    @ApiModelProperty("项目id")
    private Long projectId;

    /**
     * 转化为数据源DTO对象
     *
     * @return {@link DataSourceDTO}
     */
    public DataSourceDTO toDataSourceDTO() {
        return new DataSourceDTO(name, driver, url, username, password);
    }

}
