package org.matrix.testNg.utils;

/**
 * @author MRY
 */
public class SecToTime {

    public static Duration secToTime(Long time) {
        String timeStr = null;
        Long hour = 0L;
        Long minute = 0L;
        Long second = 0L;
        if (time <= 0) {
            return new Duration(0, 0, 0);
        } else {
            minute = time / 60;
            if (minute < 60) {
                second = time % 60;
                timeStr = unitFormat(minute) + ":" + unitFormat(second);
            } else {
                hour = minute / 60;
                if (hour > 99) {
                    return new Duration(59, 59, 99);
                }
                minute = minute % 60;
                second = time - hour * 3600 - minute * 60;
                timeStr = unitFormat(hour) + ":" + unitFormat(minute) + ":" + unitFormat(second);
            }
        }
        return new Duration(Integer.parseInt(unitFormat(second)),
                Integer.parseInt(unitFormat(minute)),
                Integer.parseInt(unitFormat(hour)));
    }

    private static String unitFormat(Long i) {
        String retStr = null;
        if (i >= 0 && i < 10) {
            retStr = "0" + i;
        } else {
            retStr = "" + i;
        }
        return retStr;
    }
}
