package org.matrix.remote.service;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import org.matrix.local.mapper.KsProjectMapper;
import org.matrix.local.mapper.KsUserMapper;
import org.matrix.local.mapper.KsUserProjectMapper;
import org.matrix.remote.entity.ZtProject;
import org.matrix.remote.entity.ZtUser;
import org.matrix.remote.entity.ZtUserView;
import org.matrix.remote.mapper.ZtProjectMapper;
import org.matrix.remote.mapper.ZtUserMapper;
import org.matrix.remote.mapper.ZtUserViewMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * 禅道数据全量同步工具
 */
@Service
public class DataAllCollector {

    @Autowired
    private ZtUserMapper ztUserMapper;
    @Autowired
    private ZtUserViewMapper ztUserViewMapper;
    @Autowired
    private ZtProjectMapper ztProjectMapper;
    @Autowired
    private KsUserMapper ksUserMapper;
    @Autowired
    private KsProjectMapper ksProjectMapper;
    @Autowired
    private KsUserProjectMapper ksUserProjectMapper;
    @Autowired
    private TransHelper transHelper;

    private List<ZtUser> ztUsers = new ArrayList<>();
    private List<ZtUserView> ztUserViews = new ArrayList<>();
    private List<ZtProject> ztProjects = new ArrayList<>();

    /**
     * 执行一次全量同步
     */
    public void execute() {
        //用户数据
        collectUser();
        saveUser();
        //项目数据
        collectProject();
        saveProject();
        //用户项目关系数据
        collectUserView();
        saveUserProject();
    }

    //------------------------------------private-------------------------------------

    /**
     * 从禅道数据库读取用户数据
     */
    private void collectUser() {
        ztUsers.clear();
        ztUsers = ztUserMapper.selectList(Wrappers.lambdaQuery());
    }


    /**
     * 从禅道数据库读取项目数据
     */
    private void collectProject() {
        ztProjects.clear();
        ztProjects = ztProjectMapper.selectList(Wrappers.<ZtProject>lambdaQuery()
                .eq(ZtProject::getDeleted, "0")
                .eq(ZtProject::getProject, 0));
    }

    /**
     * 从禅道数据库读取用户相关项目关系数据
     */
    private void collectUserView() {
        ztUserViews.clear();
        ztUserViews = ztUserViewMapper.selectList(Wrappers.lambdaQuery());
    }

    /**
     * 将用户数据保存到本地
     */
    private void saveUser() {
        ksUserMapper.delete(Wrappers.lambdaQuery());
        ztUsers.stream()
                .map(transHelper::user)
                .forEach(ksUserMapper::insert);
    }

    /**
     * 将项目数据保存到本地
     */
    private void saveProject() {
        ksProjectMapper.delete(Wrappers.lambdaQuery());
        ztProjects.stream()
                .map(transHelper::project)
                .forEach(ksProjectMapper::insert);
    }

    /**
     * 将用户项目关系数据保存到本地
     */
    private void saveUserProject() {
        ksUserProjectMapper.delete(Wrappers.lambdaQuery());
        ztUserViews.stream()
                .flatMap(ztUserView -> transHelper.userProjects(ztUserView).stream())
                .forEach(ksUserProjectMapper::insert);
    }

}
